/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.List;
import java.util.Map;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.protocol.netty.NettyServer;
import pl.skidam.automodpack_core.protocol.netty.TrafficShaper;
import pl.skidam.automodpack_core.protocol.netty.handler.CompressionDecoder;
import pl.skidam.automodpack_core.protocol.netty.handler.CompressionEncoder;
import pl.skidam.automodpack_core.protocol.netty.handler.ConfigurationHandler;
import pl.skidam.automodpack_core.protocol.netty.handler.ErrorPrinter;
import pl.skidam.automodpack_core.protocol.netty.handler.ProtocolMessageDecoder;
import pl.skidam.automodpack_core.protocol.netty.handler.ServerMessageHandler;

public class ProtocolServerHandler
extends ByteToMessageDecoder {
    private final SslContext sslCtx;

    public ProtocolServerHandler(SslContext sslCtx) {
        this.sslCtx = sslCtx;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 4) {
            return;
        }
        int magic = in.getInt(0);
        if (magic == 1095585091) {
            in.skipBytes(4);
            ByteBuf response = ctx.alloc().buffer(4);
            response.writeInt(1095585611);
            ctx.writeAndFlush((Object)response);
            Map handlers = ctx.pipeline().toMap();
            handlers.forEach((name, handler) -> ctx.pipeline().remove(handler));
            this.setupPipeline(ctx);
        } else if (this.sslCtx == null || GlobalVariables.serverConfig.bindPort != -1) {
            this.setupPipeline(ctx);
        }
        if (ctx.channel().pipeline().get(((Object)((Object)this)).getClass()) != null) {
            ctx.channel().pipeline().remove((ChannelHandler)this);
        }
    }

    private void setupPipeline(ChannelHandlerContext ctx) {
        ctx.pipeline().addLast("error-printer-first", (ChannelHandler)new ErrorPrinter());
        ctx.pipeline().addLast("traffic-shaper", (ChannelHandler)TrafficShaper.trafficShaper.getTrafficShapingHandler());
        if (this.sslCtx != null) {
            ctx.pipeline().addLast("tls", (ChannelHandler)this.sslCtx.newHandler(ctx.alloc()));
            GlobalVariables.LOGGER.debug("Added TLS handler to the pipeline");
        } else {
            GlobalVariables.LOGGER.debug("No TLS handler added to the pipeline");
        }
        ctx.channel().attr(NettyServer.PROTOCOL_VERSION).set((Object)1);
        ctx.channel().attr(NettyServer.COMPRESSION_TYPE).set((Object)1);
        ctx.channel().attr(NettyServer.CHUNK_SIZE).set((Object)131072);
        ctx.pipeline().addLast("configuration-handler", (ChannelHandler)new ConfigurationHandler()).addLast("compression-encoder", (ChannelHandler)new CompressionEncoder()).addLast("compression-decoder", (ChannelHandler)new CompressionDecoder()).addLast("chunked-write", (ChannelHandler)new ChunkedWriteHandler()).addLast("protocol-msg-decoder", (ChannelHandler)new ProtocolMessageDecoder()).addLast("msg-handler", (ChannelHandler)new ServerMessageHandler()).addLast("error-printer-last", (ChannelHandler)new ErrorPrinter());
    }
}

