/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.apache.hc.core5.http.protocol;

import amp_libs.org.apache.hc.core5.annotation.Contract;
import amp_libs.org.apache.hc.core5.annotation.ThreadingBehavior;
import amp_libs.org.apache.hc.core5.http.EntityDetails;
import amp_libs.org.apache.hc.core5.http.HttpException;
import amp_libs.org.apache.hc.core5.http.HttpRequest;
import amp_libs.org.apache.hc.core5.http.HttpRequestInterceptor;
import amp_libs.org.apache.hc.core5.http.HttpVersion;
import amp_libs.org.apache.hc.core5.http.ProtocolVersion;
import amp_libs.org.apache.hc.core5.http.protocol.HttpContext;
import amp_libs.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    public static final RequestExpectContinue INSTANCE = new RequestExpectContinue();

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && entity != null) {
            ProtocolVersion ver = context.getProtocolVersion();
            if (entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

